class Ability
  include CanCan::Ability

  def initialize(user)
    # Define abilities for the passed in user here. For example:
    #
    #   user ||= User.new # guest user (not logged in)
    #   if user.admin?
    #     can :manage, :all
    #   else
    #     can :read, :all
    #   end
    #
    # The first argument to `can` is the action you are giving the user 
    # permission to do.
    # If you pass :manage it will apply to every action. Other common actions
    # here are :read, :create, :update and :destroy.
    #
    # The second argument is the resource the user can perform the action on. 
    # If you pass :all it will apply to every resource. Otherwise pass a Ruby
    # class of the resource.
    #
    # The third argument is an optional hash of conditions to further filter the
    # objects.
    # For example, here the user can only update published articles.
    #
    #   can :update, Article, :published => true
    #
    # See the wiki for details:
    # https://github.com/ryanb/cancan/wiki/Defining-Abilities
    user ||= User.new # guest user
    unless user.new_record?
      user.role.try(:privileges).try(:each) do | priv |
        send(priv.name)
      end
    end
    can :view, :all
  end

  def create_content
    can :manage, Course
    can :manage, Certification
    can :manage, LiveEvent
    can :manage, WebText
    can :manage, Document
    can :manage, WebLink
    can :manage, Questionnaire
    can :manage, Content
    can :manage, Post
    can :manage, Group
    can :manage, InPersonEvent
    can :manage, Bundle
  end
  
  def view_content
    can :view, :all
    can [:view, :update, :destroy], LiveEvent
    can [:view, :update, :destroy], InPersonEvent
  end
  
  def all
    can :manage, :all   
  end

  def destroy_content
    can :manage, :all
  end
  
  def destroy_all
    can :manage, :all
  end
end
