module Types
  class QueryType < Types::BaseObject
    field :all_courses, [Types::CourseType], null: false
    field :get_course, CourseType, null: false do
      argument :id, ID, required: true
    end
    field :get_content, ContentType, null: false do
      argument :id, ID, required: true
    end

    def all_courses
      Course.all
    end

    def get_course(id:)
      Course.find(id)
    end

    def get_content(id:)
      Content.find(id)
    end
  end
end
